<?php

/*
 * Plugin Name:       Shop Manager Pro
 * Plugin URI:        https://shopmanagerpro.com
 * Version:           0.1.47
 * Description:       Shop Manager Pro is a powerful management GUI for WooCommerce shop owners.
 * Author:            Swabian Software Solutions
 * License:           GPL-3.0-or-later
 * Text Domain:       shopmanagerpro
 * Requires Plugins:  woocommerce
 */

if (!defined('ABSPATH')) {
	exit;
}

define('SHOP_MANAGER_PRO_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('SHOP_MANAGER_PRO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('SHOP_MANAGER_PRO_PLUGIN_URL', plugin_dir_url(__FILE__));
define('SHOP_MANAGER_PRO_VERSION', '0.1.47');
define('SHOP_MANAGER_PRO_COMMERCIAL', file_exists(SHOP_MANAGER_PRO_PLUGIN_DIR.'includes/Premium/InitService.php'));

spl_autoload_register(function ($class_name) {
	if (strpos($class_name, 'ShopManagerPro\\') !== 0) {
		return;
	}

	$class_file = str_replace('\\', '/', substr($class_name, 15));
	$class_path = SHOP_MANAGER_PRO_PLUGIN_DIR.'includes/'.$class_file.'.php';

	if (file_exists($class_path)) {
		require_once $class_path;
	}
});

add_action('plugins_loaded', '\ShopManagerPro\Shared\InitService::init');
