<?php

namespace ShopManagerPro\Taxonomies;

class TaxonomyAPI {
	public const SCHEMA = ['title' => 'taxonomies', 'type' => 'object', 'additionalProperties' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['key', 'name', 'terms'], 'properties' => ['key' => ['type' => 'string'], 'name' => ['type' => 'string'], 'terms' => ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['name'], 'properties' => ['name' => ['type' => 'string']]]]]]];

	public static function init() {
		add_action('rest_api_init', [self::class, 'registerRoutes']);
	}

	public static function registerRoutes() {
		register_rest_route(\ShopManagerPro\Shared\Utils\Constants::API_NAMESPACE, '/taxonomies', [['methods' => 'GET', 'callback' => [self::class, 'getTaxonomies'], 'permission_callback' => [\ShopManagerPro\Shared\CapabilityService::class, 'requireReadCapability']], 'schema' => fn () => self::SCHEMA]);
	}

	public static function getTaxonomies(\WP_REST_Request $request) {
		$taxonomies = TaxonomyRepository::getTaxonomies();

		return rest_ensure_response($taxonomies->taxonomiesByKey);
	}
}
