<?php

namespace ShopManagerPro\TaxClasses;

class TaxClassAPI {
	public const SCHEMA = ['title' => 'taxClasses', 'type' => 'array', 'items' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['key', 'name'], 'properties' => ['key' => ['type' => 'string'], 'name' => ['type' => 'string']]]];

	public static function init() {
		add_action('rest_api_init', [self::class, 'registerRoutes']);
	}

	public static function registerRoutes() {
		register_rest_route(\ShopManagerPro\Shared\Utils\Constants::API_NAMESPACE, '/taxClasses', [['methods' => 'GET', 'callback' => [self::class, 'getTaxClasses'], 'permission_callback' => [\ShopManagerPro\Shared\CapabilityService::class, 'requireReadCapability']], 'schema' => fn () => self::SCHEMA]);
	}

	public static function getTaxClasses(\WP_REST_Request $request) {
		$taxClasses = array_map(fn ($taxClass) => ['key' => $taxClass->slug, 'name' => $taxClass->name], \WC_Tax::get_tax_rate_classes());

		return rest_ensure_response($taxClasses);
	}
}
