<?php

namespace ShopManagerPro\Shared\Utils;

class Logger {
	private const PREFIX = 'Shop Manager Pro';
	public const LEVEL_DEBUG = 'DEBUG';
	public const LEVEL_INFO = 'INFO';
	public const LEVEL_WARNING = 'WARNING';
	public const LEVEL_ERROR = 'ERROR';

	public static function debug(string $message, array $context = []) {
		if (!self::isDebugEnabled()) {
			return;
		} self::log(self::LEVEL_DEBUG, $message, $context);
	}

	public static function info(string $message, array $context = []) {
		self::log(self::LEVEL_INFO, $message, $context);
	}

	public static function error(string $message, array $context = []) {
		self::log(self::LEVEL_ERROR, $message, $context);
	}

	public static function exception(string $message, \Throwable $exception, array $context = []) {
		$context['class'] = get_class($exception);
		$context['message'] = $exception->getMessage();
		$context['file'] = $exception->getFile();
		$context['line'] = $exception->getLine();
		$context['trace'] = $exception->getTraceAsString();
		self::log(self::LEVEL_ERROR, $message, $context);
	}

	private static function log(string $level, string $message, array $context = []) {
		$formattedMessage = sprintf('[%s] [%s] %s', self::PREFIX, $level, $message);
		if (!empty($context)) {
			$formattedMessage .= ' | '.JSON::encode($context);
		} error_log($formattedMessage);
	}

	private static function isDebugEnabled() {
		return defined('WP_DEBUG') && WP_DEBUG && defined('WP_DEBUG_LOG') && WP_DEBUG_LOG;
	}
}
