<?php

namespace ShopManagerPro\Shared\Utils;

class JSONSchema {
	public static function convertToWordPressSpec(array $schema) {
		if ($schema['type'] !== 'object') {
			throw new \InvalidArgumentException('Schema must be of type "object".');
		} if (!isset($schema['properties'])) {
			throw new \InvalidArgumentException('Schema must have "properties".');
		} $requiredFields = $schema['required'] ?? [];
		$properties = [];
		foreach ($schema['properties'] as $propertyName => $propertySpec) {
			$properties[$propertyName] = $propertySpec;
			if (in_array($propertyName, $requiredFields, true)) {
				$properties[$propertyName]['required'] = true;
			}
		}

return $properties;
	}
}
