<?php

namespace ShopManagerPro\Products\Groups\DTO;

class ProductGroupUpdate {
	public ?ProductGroupOperation $add;
	public ?ProductGroupOperation $remove;

	public function __construct(?ProductGroupOperation $add = null, ?ProductGroupOperation $remove = null) {
		$this->add = $add;
		$this->remove = $remove;
	}

	public static function fromArray(array $data) {
		return new self(add: isset($data['add']) ? ProductGroupOperation::fromArray($data['add']) : null, remove: isset($data['remove']) ? ProductGroupOperation::fromArray($data['remove']) : null);
	}

	public function hasOperations() {
		return $this->add !== null || $this->remove !== null;
	}

	public function getOperationTypes() {
		$types = [];
		if ($this->add !== null) {
			$types[] = 'add';
		} if ($this->remove !== null) {
			$types[] = 'remove';
		}

return $types;
	}
}
