<?php

namespace ShopManagerPro\Products\Groups\DTO;

use ShopManagerPro\Products\Fields\FieldNameEncoderService;

class ProductGroupOperation {
	public array $fields;

	public function __construct(array $fields) {
		$this->validateFields($fields);
		$this->fields = $fields;
	}

	public static function fromArray(array $fields) {
		return new self($fields);
	}

	private function validateFields(array $fields) {
		foreach ($fields as $fieldKey => $values) {
			try {
				FieldNameEncoderService::decode($fieldKey);
			} catch (\ValueError $e) {
				throw new \InvalidArgumentException("Invalid field key format: {$fieldKey}. Fields must use type:key format (e.g., defaultTaxonomy:product_cat, acf:123)");
			} if (!is_array($values)) {
				throw new \InvalidArgumentException("Field values must be an array for field: {$fieldKey}");
			}
		}
	}

	public function getFieldValues(string $field) {
		return $this->fields[$field] ?? [];
	}

	public function hasField(string $field) {
		return isset($this->fields[$field]);
	}
}
