<?php

namespace ShopManagerPro\Products\Fields;

class ProductFieldAPI {
	public static function init() {
		add_action('rest_api_init', [self::class, 'registerRoutes']);
	}

	public static function schema() {
		return array_merge(['title' => 'productFields'], ProductFieldRepository::getProductFieldsSchema());
	}

	public static function registerRoutes() {
		register_rest_route(\ShopManagerPro\Shared\Utils\Constants::API_NAMESPACE, '/productFields', [['methods' => 'GET', 'callback' => [self::class, 'getProductFields'], 'permission_callback' => [\ShopManagerPro\Shared\CapabilityService::class, 'requireReadCapability']], 'schema' => fn () => self::schema()]);
	}

	public static function getProductFields(\WP_REST_Request $request) {
		return rest_ensure_response(ProductFieldRepository::getProductFields(true)->toProductFieldValues());
	}
}
