<?php

namespace ShopManagerPro\Products\Fields;

use ShopManagerPro\Products\Fields\DTO\ProductField;
use ShopManagerPro\Products\Fields\DTO\ProductFieldGroupType;

class FieldNameEncoderService {
	public static function decode(string $encoded) {
		$parts = explode(ProductField::FIELD_TYPE_SEPARATOR, $encoded, 2);
		if (count($parts) !== 2) {
			throw new \ValueError('Invalid field format: field must contain a type separator. encoded='.json_encode($encoded));
		} [$typeStr, $key] = $parts;
		$type = ProductFieldGroupType::from($typeStr);

		return new DTO\FieldIdentifier(type: $type, key: $key);
	}
}
