<?php

namespace ShopManagerPro\Products\Fields\DTO;

use ShopManagerPro\Shared\Utils\Logger;

enum ProductFieldType: string {
	case BOOLEAN = 'boolean';
	case CURRENCY = 'currency';
	case DATETIME = 'datetime';
	case INTEGER = 'integer';
	case MULTISELECT = 'multiselect';
	case POSITIVE_INTEGER = 'positive_integer';
	case SELECT = 'select';
	case TEXT = 'text';
	private const TYPE_TO_OPENAPI_TYPE = [ProductFieldType::BOOLEAN->value => 'boolean', ProductFieldType::CURRENCY->value => 'number', ProductFieldType::DATETIME->value => 'string', ProductFieldType::INTEGER->value => 'integer', ProductFieldType::MULTISELECT->value => 'array', ProductFieldType::POSITIVE_INTEGER->value => 'integer', ProductFieldType::SELECT->value => 'string', ProductFieldType::TEXT->value => 'string'];

	public function toOpenAPIType(): string {
		if (isset(self::TYPE_TO_OPENAPI_TYPE[$this->value])) {
			return self::TYPE_TO_OPENAPI_TYPE[$this->value];
		} Logger::error('Invalid ProductFieldType', ['type' => $this->value]);

		return $this->value;
	}
}
