<?php

namespace ShopManagerPro\Products\Fields\DTO;

use ShopManagerPro\Filters\DTO\Generated\FilterConditionsItem;

class FieldIdentifier {
	public function __construct(public readonly ProductFieldGroupType $type, public readonly string $key) {
	}

	public static function fromFilterCondition(FilterConditionsItem $condition) {
		$field = $condition->getField();
		$type = ProductFieldGroupType::from($field->getType()->value);
		$key = $field->getKey();

		return new self($type, $key);
	}
}
