<?php

namespace ShopManagerPro\Products\Fields\DTO\Basic;

use ShopManagerPro\Products\Fields\DTO\ProductFieldGroupType;

class BasicFieldGroup {
	public const KEY = ProductFieldGroupType::BASIC->value;

	public function __construct(public readonly array $fields) {
	}

	public function toProductFieldValues() {
		return array_map(fn ($field) => $field->toProductFieldValues(), $this->fields);
	}

	public function toProductFieldSchema() {
		$properties = [];
		foreach ($this->fields as $key => $field) {
			$properties[$key] = $field->toProductFieldSchema();
		}

return ['type' => 'object', 'required' => array_keys($properties), 'properties' => $properties];
	}

	public function toProductSchema() {
		$properties = [];
		foreach ($this->fields as $key => $field) {
			$properties[$key] = $field->toProductSchema();
		}

return ['type' => 'object', 'required' => array_keys($properties), 'properties' => $properties];
	}
}
