<?php

namespace ShopManagerPro\Products\Fields\DTO;

class AllProductFields {
	public function __construct(public ACF\ACFFieldGroup $acf, public Basic\BasicFieldGroup $basic, public CustomMeta\CustomMetaGroup $customMeta, public DefaultTaxonomy\DefaultTaxonomyFieldGroup $defaultTaxonomies, public ProductAttributes\ProductAttributeFieldGroup $productAttributes) {
	}

	public function toProductFieldSchema() {
		return ['type' => 'object', 'required' => [ACF\ACFFieldGroup::KEY, Basic\BasicFieldGroup::KEY, CustomMeta\CustomMetaGroup::KEY, DefaultTaxonomy\DefaultTaxonomyFieldGroup::KEY, ProductAttributes\ProductAttributeFieldGroup::KEY], 'additionalProperties' => false, 'properties' => [ACF\ACFFieldGroup::KEY => $this->acf->toProductFieldSchema(), Basic\BasicFieldGroup::KEY => $this->basic->toProductFieldSchema(), CustomMeta\CustomMetaGroup::KEY => $this->customMeta->toProductFieldSchema(), DefaultTaxonomy\DefaultTaxonomyFieldGroup::KEY => $this->defaultTaxonomies->toProductFieldSchema(), ProductAttributes\ProductAttributeFieldGroup::KEY => $this->productAttributes->toProductFieldSchema()]];
	}

	public function toProductFieldValues() {
		return [ACF\ACFFieldGroup::KEY => $this->acf->toProductFieldValues(), Basic\BasicFieldGroup::KEY => $this->basic->toProductFieldValues(), CustomMeta\CustomMetaGroup::KEY => $this->customMeta->toProductFieldValues(), DefaultTaxonomy\DefaultTaxonomyFieldGroup::KEY => $this->defaultTaxonomies->toProductFieldValues(), ProductAttributes\ProductAttributeFieldGroup::KEY => $this->productAttributes->toProductFieldValues()];
	}

	public function toProductSchema() {
		return ['type' => 'object', 'required' => [ACF\ACFFieldGroup::KEY, Basic\BasicFieldGroup::KEY, CustomMeta\CustomMetaGroup::KEY, DefaultTaxonomy\DefaultTaxonomyFieldGroup::KEY, ProductAttributes\ProductAttributeFieldGroup::KEY], 'additionalProperties' => false, 'properties' => [ACF\ACFFieldGroup::KEY => $this->acf->toProductSchema(), Basic\BasicFieldGroup::KEY => $this->basic->toProductSchema(), CustomMeta\CustomMetaGroup::KEY => $this->customMeta->toProductSchema(), DefaultTaxonomy\DefaultTaxonomyFieldGroup::KEY => $this->defaultTaxonomies->toProductSchema(), ProductAttributes\ProductAttributeFieldGroup::KEY => $this->productAttributes->toProductSchema()]];
	}
}
