<?php

namespace ShopManagerPro\Products\DTO;

use ShopManagerPro\Jobs\DTO\Generated\JobProductsItemErrorAlternative1;
use ShopManagerPro\Jobs\DTO\Generated\JobProductsItemErrorAlternative2;
use ShopManagerPro\Shared\Utils\JSON;

class ProductUpdateException extends \Exception {
	public readonly JobProductsItemErrorAlternative1|JobProductsItemErrorAlternative2 $error;

	public function __construct(JobProductsItemErrorAlternative1|JobProductsItemErrorAlternative2 $error) {
		parent::__construct(JSON::encode($error->toJson()));
		$this->error = $error;
	}
}
