<?php

declare(strict_types=1);

namespace ShopManagerPro\Products\DTO\Generated;

class ProductBulkUpdateActions {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'properties' => ['basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'integer'], 'parentId' => ['type' => 'integer'], 'name' => ['type' => 'string'], 'descriptionLong' => ['type' => 'string'], 'descriptionShort' => ['type' => 'string'], 'imageId' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'galleryImageIds' => ['type' => 'array', 'items' => ['type' => 'integer']], 'postStatus' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'sku' => ['type' => 'string'], 'regularPrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'salePrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'stock' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'stockStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'taxClass' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'taxStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'totalSales' => ['type' => 'integer']]], 'special' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['regularPriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'regularPricePercentage' => ['type' => 'number'], 'regularPriceAbsolute' => ['type' => 'number'], 'regularPriceUseSaleAsReference' => ['type' => 'boolean'], 'salePriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'salePricePercentage' => ['type' => 'number'], 'salePriceAbsolute' => ['type' => 'number'], 'salePriceUseRegularAsReference' => ['type' => 'boolean'], 'productGroupUpdates' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['add' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]], 'remove' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]]]]]]]];
	private ?ProductBulkUpdateActionsBasic $basic = null;
	private ?ProductBulkUpdateActionsSpecial $special = null;

	public function __construct() {
	}

	public function getBasic(): ?ProductBulkUpdateActionsBasic {
		return $this->basic ?? null;
	}

	public function getSpecial(): ?ProductBulkUpdateActionsSpecial {
		return $this->special ?? null;
	}

	public function withBasic(ProductBulkUpdateActionsBasic $basic): self {
		$clone = clone $this;
		$clone->basic = $basic;

		return $clone;
	}

	public function withoutBasic(): self {
		$clone = clone $this;
		unset($clone->basic);

		return $clone;
	}

	public function withSpecial(ProductBulkUpdateActionsSpecial $special): self {
		$clone = clone $this;
		$clone->special = $special;

		return $clone;
	}

	public function withoutSpecial(): self {
		$clone = clone $this;
		unset($clone->special);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): ProductBulkUpdateActions {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $basic = null;
		if (isset($input->{'basic'})) {
			$basic = ProductBulkUpdateActionsBasic::buildFromInput($input->{'basic'}, validate: $validate);
		} $special = null;
		if (isset($input->{'special'})) {
			$special = ProductBulkUpdateActionsSpecial::buildFromInput($input->{'special'}, validate: $validate);
		} $obj = new self();
		$obj->basic = $basic;
		$obj->special = $special;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->basic)) {
			$output['basic'] = $this->basic->toJson();
		} if (isset($this->special)) {
			$output['special'] = $this->special->toJson();
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->basic)) {
			$this->basic = clone $this->basic;
		} if (isset($this->special)) {
			$this->special = clone $this->special;
		}
	}
}
