<?php

declare(strict_types=1);

namespace ShopManagerPro\Products\DTO\Generated;

class ProductBulkUpdate {
	private static array $schema = ['title' => 'productsBulkUpdate', 'type' => 'object', 'required' => ['productIds', 'actions'], 'properties' => ['productIds' => ['type' => 'array', 'items' => ['type' => 'integer']], 'actions' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'integer'], 'parentId' => ['type' => 'integer'], 'name' => ['type' => 'string'], 'descriptionLong' => ['type' => 'string'], 'descriptionShort' => ['type' => 'string'], 'imageId' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'galleryImageIds' => ['type' => 'array', 'items' => ['type' => 'integer']], 'postStatus' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'sku' => ['type' => 'string'], 'regularPrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'salePrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'stock' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'stockStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'taxClass' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'taxStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'totalSales' => ['type' => 'integer']]], 'special' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['regularPriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'regularPricePercentage' => ['type' => 'number'], 'regularPriceAbsolute' => ['type' => 'number'], 'regularPriceUseSaleAsReference' => ['type' => 'boolean'], 'salePriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'salePricePercentage' => ['type' => 'number'], 'salePriceAbsolute' => ['type' => 'number'], 'salePriceUseRegularAsReference' => ['type' => 'boolean'], 'productGroupUpdates' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['add' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]], 'remove' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]]]]]]]]]];
	private array $productIds;
	private ProductBulkUpdateActions $actions;

	public function __construct(array $productIds, ProductBulkUpdateActions $actions) {
		$this->productIds = $productIds;
		$this->actions = $actions;
	}

	public function getProductIds(): array {
		return $this->productIds;
	}

	public function getActions(): ProductBulkUpdateActions {
		return $this->actions;
	}

	public function withProductIds(array $productIds): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($productIds, self::$schema['properties']['productIds']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->productIds = $productIds;

		return $clone;
	}

	public function withActions(ProductBulkUpdateActions $actions): self {
		$clone = clone $this;
		$clone->actions = $actions;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): ProductBulkUpdate {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $productIds = $input->{'productIds'};
		$actions = ProductBulkUpdateActions::buildFromInput($input->{'actions'}, validate: $validate);
		$obj = new self($productIds, $actions);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['productIds'] = $this->productIds;
		$output['actions'] = $this->actions->toJson();

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->actions = clone $this->actions;
	}
}
