<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemErrorAlternative2 {
	private static array $schema = ['type' => ['object'], 'required' => ['message'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['unknown_error'], 'default' => 'unknown_error'], 'message' => ['type' => 'string']]];
	private JobProductsItemErrorAlternative2Code $code = JobProductsItemErrorAlternative2Code::unknownerror;
	private string $message;

	public function __construct(string $message) {
		$this->message = $message;
	}

	public function getCode(): JobProductsItemErrorAlternative2Code {
		return $this->code;
	}

	public function getMessage(): string {
		return $this->message;
	}

	public function withCode(JobProductsItemErrorAlternative2Code $code): self {
		$clone = clone $this;
		$clone->code = $code;

		return $clone;
	}

	public function withoutCode(): self {
		$clone = clone $this;
		$clone->code = JobProductsItemErrorAlternative2Code::unknownerror;

		return $clone;
	}

	public function withMessage(string $message): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($message, self::$schema['properties']['message']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->message = $message;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemErrorAlternative2 {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $code = JobProductsItemErrorAlternative2Code::unknownerror;
		if (isset($input->{'code'})) {
			$code = JobProductsItemErrorAlternative2Code::from($input->{'code'});
		} $message = $input->{'message'};
		$obj = new self($message);
		$obj->code = $code;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->code)) {
			$output['code'] = $this->code->value;
		} $output['message'] = $this->message;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
