<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesBasicTaxClass {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]]]];
	private $old;
	private $new;

	public function __construct($old, $new) {
		$this->old = $old;
		$this->new = $new;
	}

	public function getOld() {
		return $this->old;
	}

	public function getNew() {
		return $this->new;
	}

	public function withOld($old): self {
		$clone = clone $this;
		$clone->old = $old;

		return $clone;
	}

	public function withNew($new): self {
		$clone = clone $this;
		$clone->new = $new;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesBasicTaxClass {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $old = match (true) {
			is_string($input->{'old'}), true => $input->{'old'}, default => throw new \InvalidArgumentException("could not build property 'old' from JSON"),
		};
		$new = match (true) {
			is_string($input->{'new'}), true => $input->{'new'}, default => throw new \InvalidArgumentException("could not build property 'new' from JSON"),
		};
		$obj = new self($old, $new);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['old'] = match (true) {
			is_string($this->old), true => $this->old,
		};
		$output['new'] = match (true) {
			is_string($this->new), true => $this->new,
		};

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->old = match (true) {
			is_string($this->old), true => $this->old,
		};
		$this->new = match (true) {
			is_string($this->new), true => $this->new,
		};
	}
}
