<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesBasicSalePrice {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]];
	private $old;
	private $new;

	public function __construct($old, $new) {
		$this->old = $old;
		$this->new = $new;
	}

	public function getOld() {
		return $this->old;
	}

	public function getNew() {
		return $this->new;
	}

	public function withOld($old): self {
		$clone = clone $this;
		$clone->old = $old;

		return $clone;
	}

	public function withNew($new): self {
		$clone = clone $this;
		$clone->new = $new;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesBasicSalePrice {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $old = match (true) {
			is_int($input->{'old'}) || is_float($input->{'old'}), true => $input->{'old'}, default => throw new \InvalidArgumentException("could not build property 'old' from JSON"),
		};
		$new = match (true) {
			is_int($input->{'new'}) || is_float($input->{'new'}), true => $input->{'new'}, default => throw new \InvalidArgumentException("could not build property 'new' from JSON"),
		};
		$obj = new self($old, $new);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['old'] = match (true) {
			is_int($this->old) || is_float($this->old), true => $this->old,
		};
		$output['new'] = match (true) {
			is_int($this->new) || is_float($this->new), true => $this->new,
		};

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->old = match (true) {
			is_int($this->old) || is_float($this->old), true => $this->old,
		};
		$this->new = match (true) {
			is_int($this->new) || is_float($this->new), true => $this->new,
		};
	}
}
