<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesBasicPostStatus {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'new' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']]]];
	private JobProductsItemChangesBasicPostStatusOld $old;
	private JobProductsItemChangesBasicPostStatusNew $new;

	public function __construct(JobProductsItemChangesBasicPostStatusOld $old, JobProductsItemChangesBasicPostStatusNew $new) {
		$this->old = $old;
		$this->new = $new;
	}

	public function getOld(): JobProductsItemChangesBasicPostStatusOld {
		return $this->old;
	}

	public function getNew(): JobProductsItemChangesBasicPostStatusNew {
		return $this->new;
	}

	public function withOld(JobProductsItemChangesBasicPostStatusOld $old): self {
		$clone = clone $this;
		$clone->old = $old;

		return $clone;
	}

	public function withNew(JobProductsItemChangesBasicPostStatusNew $new): self {
		$clone = clone $this;
		$clone->new = $new;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesBasicPostStatus {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $old = JobProductsItemChangesBasicPostStatusOld::from($input->{'old'});
		$new = JobProductsItemChangesBasicPostStatusNew::from($input->{'new'});
		$obj = new self($old, $new);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['old'] = $this->old->value;
		$output['new'] = $this->new->value;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
