<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesAcf {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]], 'new' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]]], 'required' => ['old', 'new']];
	private array $old;
	private array $new;

	public function __construct(array $old, array $new) {
		$this->old = $old;
		$this->new = $new;
	}

	public function getOld(): array {
		return $this->old;
	}

	public function getNew(): array {
		return $this->new;
	}

	public function withOld(array $old): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($old, self::$schema['properties']['old']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->old = $old;

		return $clone;
	}

	public function withNew(array $new): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($new, self::$schema['properties']['new']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->new = $new;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesAcf {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $old = (array) $input->{'old'};
		$new = (array) $input->{'new'};
		$obj = new self($old, $new);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['old'] = $this->old;
		$output['new'] = $this->new;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
