<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobActionsSpecial {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'properties' => ['regularPriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'regularPricePercentage' => ['type' => 'number'], 'regularPriceAbsolute' => ['type' => 'number'], 'regularPriceUseSaleAsReference' => ['type' => 'boolean'], 'salePriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'salePricePercentage' => ['type' => 'number'], 'salePriceAbsolute' => ['type' => 'number'], 'salePriceUseRegularAsReference' => ['type' => 'boolean'], 'productGroupUpdates' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['add' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]], 'remove' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]]]]]];
	private ?JobActionsSpecialRegularPriceMode $regularPriceMode = null;
	private int|float|null $regularPricePercentage = null;
	private int|float|null $regularPriceAbsolute = null;
	private ?bool $regularPriceUseSaleAsReference = null;
	private ?JobActionsSpecialSalePriceMode $salePriceMode = null;
	private int|float|null $salePricePercentage = null;
	private int|float|null $salePriceAbsolute = null;
	private ?bool $salePriceUseRegularAsReference = null;
	private ?JobActionsSpecialProductGroupUpdates $productGroupUpdates = null;

	public function __construct() {
	}

	public function getRegularPriceMode(): ?JobActionsSpecialRegularPriceMode {
		return $this->regularPriceMode ?? null;
	}

	public function getRegularPricePercentage(): int|float|null {
		return $this->regularPricePercentage;
	}

	public function getRegularPriceAbsolute(): int|float|null {
		return $this->regularPriceAbsolute;
	}

	public function getRegularPriceUseSaleAsReference(): ?bool {
		return $this->regularPriceUseSaleAsReference ?? null;
	}

	public function getSalePriceMode(): ?JobActionsSpecialSalePriceMode {
		return $this->salePriceMode ?? null;
	}

	public function getSalePricePercentage(): int|float|null {
		return $this->salePricePercentage;
	}

	public function getSalePriceAbsolute(): int|float|null {
		return $this->salePriceAbsolute;
	}

	public function getSalePriceUseRegularAsReference(): ?bool {
		return $this->salePriceUseRegularAsReference ?? null;
	}

	public function getProductGroupUpdates(): ?JobActionsSpecialProductGroupUpdates {
		return $this->productGroupUpdates ?? null;
	}

	public function withRegularPriceMode(JobActionsSpecialRegularPriceMode $regularPriceMode): self {
		$clone = clone $this;
		$clone->regularPriceMode = $regularPriceMode;

		return $clone;
	}

	public function withoutRegularPriceMode(): self {
		$clone = clone $this;
		unset($clone->regularPriceMode);

		return $clone;
	}

	public function withRegularPricePercentage(int|float $regularPricePercentage): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($regularPricePercentage, self::$schema['properties']['regularPricePercentage']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->regularPricePercentage = $regularPricePercentage;

		return $clone;
	}

	public function withoutRegularPricePercentage(): self {
		$clone = clone $this;
		unset($clone->regularPricePercentage);

		return $clone;
	}

	public function withRegularPriceAbsolute(int|float $regularPriceAbsolute): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($regularPriceAbsolute, self::$schema['properties']['regularPriceAbsolute']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->regularPriceAbsolute = $regularPriceAbsolute;

		return $clone;
	}

	public function withoutRegularPriceAbsolute(): self {
		$clone = clone $this;
		unset($clone->regularPriceAbsolute);

		return $clone;
	}

	public function withRegularPriceUseSaleAsReference(bool $regularPriceUseSaleAsReference): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($regularPriceUseSaleAsReference, self::$schema['properties']['regularPriceUseSaleAsReference']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->regularPriceUseSaleAsReference = $regularPriceUseSaleAsReference;

		return $clone;
	}

	public function withoutRegularPriceUseSaleAsReference(): self {
		$clone = clone $this;
		unset($clone->regularPriceUseSaleAsReference);

		return $clone;
	}

	public function withSalePriceMode(JobActionsSpecialSalePriceMode $salePriceMode): self {
		$clone = clone $this;
		$clone->salePriceMode = $salePriceMode;

		return $clone;
	}

	public function withoutSalePriceMode(): self {
		$clone = clone $this;
		unset($clone->salePriceMode);

		return $clone;
	}

	public function withSalePricePercentage(int|float $salePricePercentage): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($salePricePercentage, self::$schema['properties']['salePricePercentage']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->salePricePercentage = $salePricePercentage;

		return $clone;
	}

	public function withoutSalePricePercentage(): self {
		$clone = clone $this;
		unset($clone->salePricePercentage);

		return $clone;
	}

	public function withSalePriceAbsolute(int|float $salePriceAbsolute): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($salePriceAbsolute, self::$schema['properties']['salePriceAbsolute']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->salePriceAbsolute = $salePriceAbsolute;

		return $clone;
	}

	public function withoutSalePriceAbsolute(): self {
		$clone = clone $this;
		unset($clone->salePriceAbsolute);

		return $clone;
	}

	public function withSalePriceUseRegularAsReference(bool $salePriceUseRegularAsReference): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($salePriceUseRegularAsReference, self::$schema['properties']['salePriceUseRegularAsReference']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->salePriceUseRegularAsReference = $salePriceUseRegularAsReference;

		return $clone;
	}

	public function withoutSalePriceUseRegularAsReference(): self {
		$clone = clone $this;
		unset($clone->salePriceUseRegularAsReference);

		return $clone;
	}

	public function withProductGroupUpdates(JobActionsSpecialProductGroupUpdates $productGroupUpdates): self {
		$clone = clone $this;
		$clone->productGroupUpdates = $productGroupUpdates;

		return $clone;
	}

	public function withoutProductGroupUpdates(): self {
		$clone = clone $this;
		unset($clone->productGroupUpdates);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobActionsSpecial {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $regularPriceMode = null;
		if (isset($input->{'regularPriceMode'})) {
			$regularPriceMode = JobActionsSpecialRegularPriceMode::from($input->{'regularPriceMode'});
		} $regularPricePercentage = null;
		if (isset($input->{'regularPricePercentage'})) {
			$regularPricePercentage = str_contains((string) $input->{'regularPricePercentage'}, '.') ? (float) ($input->{'regularPricePercentage'}) : (int) ($input->{'regularPricePercentage'});
		} $regularPriceAbsolute = null;
		if (isset($input->{'regularPriceAbsolute'})) {
			$regularPriceAbsolute = str_contains((string) $input->{'regularPriceAbsolute'}, '.') ? (float) ($input->{'regularPriceAbsolute'}) : (int) ($input->{'regularPriceAbsolute'});
		} $regularPriceUseSaleAsReference = null;
		if (isset($input->{'regularPriceUseSaleAsReference'})) {
			$regularPriceUseSaleAsReference = (bool) $input->{'regularPriceUseSaleAsReference'};
		} $salePriceMode = null;
		if (isset($input->{'salePriceMode'})) {
			$salePriceMode = JobActionsSpecialSalePriceMode::from($input->{'salePriceMode'});
		} $salePricePercentage = null;
		if (isset($input->{'salePricePercentage'})) {
			$salePricePercentage = str_contains((string) $input->{'salePricePercentage'}, '.') ? (float) ($input->{'salePricePercentage'}) : (int) ($input->{'salePricePercentage'});
		} $salePriceAbsolute = null;
		if (isset($input->{'salePriceAbsolute'})) {
			$salePriceAbsolute = str_contains((string) $input->{'salePriceAbsolute'}, '.') ? (float) ($input->{'salePriceAbsolute'}) : (int) ($input->{'salePriceAbsolute'});
		} $salePriceUseRegularAsReference = null;
		if (isset($input->{'salePriceUseRegularAsReference'})) {
			$salePriceUseRegularAsReference = (bool) $input->{'salePriceUseRegularAsReference'};
		} $productGroupUpdates = null;
		if (isset($input->{'productGroupUpdates'})) {
			$productGroupUpdates = JobActionsSpecialProductGroupUpdates::buildFromInput($input->{'productGroupUpdates'}, validate: $validate);
		} $obj = new self();
		$obj->regularPriceMode = $regularPriceMode;
		$obj->regularPricePercentage = $regularPricePercentage;
		$obj->regularPriceAbsolute = $regularPriceAbsolute;
		$obj->regularPriceUseSaleAsReference = $regularPriceUseSaleAsReference;
		$obj->salePriceMode = $salePriceMode;
		$obj->salePricePercentage = $salePricePercentage;
		$obj->salePriceAbsolute = $salePriceAbsolute;
		$obj->salePriceUseRegularAsReference = $salePriceUseRegularAsReference;
		$obj->productGroupUpdates = $productGroupUpdates;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->regularPriceMode)) {
			$output['regularPriceMode'] = $this->regularPriceMode->value;
		} if (isset($this->regularPricePercentage)) {
			$output['regularPricePercentage'] = $this->regularPricePercentage;
		} if (isset($this->regularPriceAbsolute)) {
			$output['regularPriceAbsolute'] = $this->regularPriceAbsolute;
		} if (isset($this->regularPriceUseSaleAsReference)) {
			$output['regularPriceUseSaleAsReference'] = $this->regularPriceUseSaleAsReference;
		} if (isset($this->salePriceMode)) {
			$output['salePriceMode'] = $this->salePriceMode->value;
		} if (isset($this->salePricePercentage)) {
			$output['salePricePercentage'] = $this->salePricePercentage;
		} if (isset($this->salePriceAbsolute)) {
			$output['salePriceAbsolute'] = $this->salePriceAbsolute;
		} if (isset($this->salePriceUseRegularAsReference)) {
			$output['salePriceUseRegularAsReference'] = $this->salePriceUseRegularAsReference;
		} if (isset($this->productGroupUpdates)) {
			$output['productGroupUpdates'] = $this->productGroupUpdates->toJson();
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->productGroupUpdates)) {
			$this->productGroupUpdates = clone $this->productGroupUpdates;
		}
	}
}
