<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobActionsBasic {
	private static array $schema = ['type' => 'object', 'properties' => ['id' => ['type' => 'integer'], 'parentId' => ['type' => 'integer'], 'name' => ['type' => 'string'], 'descriptionLong' => ['type' => 'string'], 'descriptionShort' => ['type' => 'string'], 'imageId' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'galleryImageIds' => ['type' => 'array', 'items' => ['type' => 'integer']], 'postStatus' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'sku' => ['type' => 'string'], 'regularPrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'salePrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'stock' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'stockStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'taxClass' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'taxStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'totalSales' => ['type' => 'integer']]];
	private ?int $id = null;
	private ?int $parentId = null;
	private ?string $name = null;
	private ?string $descriptionLong = null;
	private ?string $descriptionShort = null;
	private $imageId;
	private ?array $galleryImageIds = null;
	private ?JobActionsBasicPostStatus $postStatus = null;
	private ?string $sku = null;
	private $regularPrice;
	private $salePrice;
	private $stock;
	private $stockStatus;
	private $taxClass;
	private $taxStatus;
	private ?int $totalSales = null;

	public function __construct() {
	}

	public function getId(): ?int {
		return $this->id ?? null;
	}

	public function getParentId(): ?int {
		return $this->parentId ?? null;
	}

	public function getName(): ?string {
		return $this->name ?? null;
	}

	public function getDescriptionLong(): ?string {
		return $this->descriptionLong ?? null;
	}

	public function getDescriptionShort(): ?string {
		return $this->descriptionShort ?? null;
	}

	public function getImageId() {
		return $this->imageId;
	}

	public function getGalleryImageIds(): ?array {
		return $this->galleryImageIds ?? null;
	}

	public function getPostStatus(): ?JobActionsBasicPostStatus {
		return $this->postStatus ?? null;
	}

	public function getSku(): ?string {
		return $this->sku ?? null;
	}

	public function getRegularPrice() {
		return $this->regularPrice;
	}

	public function getSalePrice() {
		return $this->salePrice;
	}

	public function getStock() {
		return $this->stock;
	}

	public function getStockStatus() {
		return $this->stockStatus;
	}

	public function getTaxClass() {
		return $this->taxClass;
	}

	public function getTaxStatus() {
		return $this->taxStatus;
	}

	public function getTotalSales(): ?int {
		return $this->totalSales ?? null;
	}

	public function withId(int $id): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($id, self::$schema['properties']['id']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->id = $id;

		return $clone;
	}

	public function withoutId(): self {
		$clone = clone $this;
		unset($clone->id);

		return $clone;
	}

	public function withParentId(int $parentId): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($parentId, self::$schema['properties']['parentId']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->parentId = $parentId;

		return $clone;
	}

	public function withoutParentId(): self {
		$clone = clone $this;
		unset($clone->parentId);

		return $clone;
	}

	public function withName(string $name): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($name, self::$schema['properties']['name']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->name = $name;

		return $clone;
	}

	public function withoutName(): self {
		$clone = clone $this;
		unset($clone->name);

		return $clone;
	}

	public function withDescriptionLong(string $descriptionLong): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($descriptionLong, self::$schema['properties']['descriptionLong']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->descriptionLong = $descriptionLong;

		return $clone;
	}

	public function withoutDescriptionLong(): self {
		$clone = clone $this;
		unset($clone->descriptionLong);

		return $clone;
	}

	public function withDescriptionShort(string $descriptionShort): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($descriptionShort, self::$schema['properties']['descriptionShort']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->descriptionShort = $descriptionShort;

		return $clone;
	}

	public function withoutDescriptionShort(): self {
		$clone = clone $this;
		unset($clone->descriptionShort);

		return $clone;
	}

	public function withImageId($imageId): self {
		$clone = clone $this;
		$clone->imageId = $imageId;

		return $clone;
	}

	public function withoutImageId(): self {
		$clone = clone $this;
		unset($clone->imageId);

		return $clone;
	}

	public function withGalleryImageIds(array $galleryImageIds): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($galleryImageIds, self::$schema['properties']['galleryImageIds']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->galleryImageIds = $galleryImageIds;

		return $clone;
	}

	public function withoutGalleryImageIds(): self {
		$clone = clone $this;
		unset($clone->galleryImageIds);

		return $clone;
	}

	public function withPostStatus(JobActionsBasicPostStatus $postStatus): self {
		$clone = clone $this;
		$clone->postStatus = $postStatus;

		return $clone;
	}

	public function withoutPostStatus(): self {
		$clone = clone $this;
		unset($clone->postStatus);

		return $clone;
	}

	public function withSku(string $sku): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($sku, self::$schema['properties']['sku']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->sku = $sku;

		return $clone;
	}

	public function withoutSku(): self {
		$clone = clone $this;
		unset($clone->sku);

		return $clone;
	}

	public function withRegularPrice($regularPrice): self {
		$clone = clone $this;
		$clone->regularPrice = $regularPrice;

		return $clone;
	}

	public function withoutRegularPrice(): self {
		$clone = clone $this;
		unset($clone->regularPrice);

		return $clone;
	}

	public function withSalePrice($salePrice): self {
		$clone = clone $this;
		$clone->salePrice = $salePrice;

		return $clone;
	}

	public function withoutSalePrice(): self {
		$clone = clone $this;
		unset($clone->salePrice);

		return $clone;
	}

	public function withStock($stock): self {
		$clone = clone $this;
		$clone->stock = $stock;

		return $clone;
	}

	public function withoutStock(): self {
		$clone = clone $this;
		unset($clone->stock);

		return $clone;
	}

	public function withStockStatus($stockStatus): self {
		$clone = clone $this;
		$clone->stockStatus = $stockStatus;

		return $clone;
	}

	public function withoutStockStatus(): self {
		$clone = clone $this;
		unset($clone->stockStatus);

		return $clone;
	}

	public function withTaxClass($taxClass): self {
		$clone = clone $this;
		$clone->taxClass = $taxClass;

		return $clone;
	}

	public function withoutTaxClass(): self {
		$clone = clone $this;
		unset($clone->taxClass);

		return $clone;
	}

	public function withTaxStatus($taxStatus): self {
		$clone = clone $this;
		$clone->taxStatus = $taxStatus;

		return $clone;
	}

	public function withoutTaxStatus(): self {
		$clone = clone $this;
		unset($clone->taxStatus);

		return $clone;
	}

	public function withTotalSales(int $totalSales): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($totalSales, self::$schema['properties']['totalSales']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->totalSales = $totalSales;

		return $clone;
	}

	public function withoutTotalSales(): self {
		$clone = clone $this;
		unset($clone->totalSales);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobActionsBasic {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $id = null;
		if (isset($input->{'id'})) {
			$id = (int) $input->{'id'};
		} $parentId = null;
		if (isset($input->{'parentId'})) {
			$parentId = (int) $input->{'parentId'};
		} $name = null;
		if (isset($input->{'name'})) {
			$name = $input->{'name'};
		} $descriptionLong = null;
		if (isset($input->{'descriptionLong'})) {
			$descriptionLong = $input->{'descriptionLong'};
		} $descriptionShort = null;
		if (isset($input->{'descriptionShort'})) {
			$descriptionShort = $input->{'descriptionShort'};
		} $imageId = null;
		if (isset($input->{'imageId'})) {
			$imageId = match (true) {
				is_int($input->{'imageId'}), true => $input->{'imageId'}, default => throw new \InvalidArgumentException("could not build property 'imageId' from JSON"),
			};
		} $galleryImageIds = null;
		if (isset($input->{'galleryImageIds'})) {
			$galleryImageIds = $input->{'galleryImageIds'};
		} $postStatus = null;
		if (isset($input->{'postStatus'})) {
			$postStatus = JobActionsBasicPostStatus::from($input->{'postStatus'});
		} $sku = null;
		if (isset($input->{'sku'})) {
			$sku = $input->{'sku'};
		} $regularPrice = null;
		if (isset($input->{'regularPrice'})) {
			$regularPrice = match (true) {
				is_int($input->{'regularPrice'}) || is_float($input->{'regularPrice'}), true => $input->{'regularPrice'}, default => throw new \InvalidArgumentException("could not build property 'regularPrice' from JSON"),
			};
		} $salePrice = null;
		if (isset($input->{'salePrice'})) {
			$salePrice = match (true) {
				is_int($input->{'salePrice'}) || is_float($input->{'salePrice'}), true => $input->{'salePrice'}, default => throw new \InvalidArgumentException("could not build property 'salePrice' from JSON"),
			};
		} $stock = null;
		if (isset($input->{'stock'})) {
			$stock = match (true) {
				is_int($input->{'stock'}), true => $input->{'stock'}, default => throw new \InvalidArgumentException("could not build property 'stock' from JSON"),
			};
		} $stockStatus = null;
		if (isset($input->{'stockStatus'})) {
			$stockStatus = match (true) {
				JobActionsBasicStockStatusAlternative1::tryFrom($input->{'stockStatus'}) !== null => JobActionsBasicStockStatusAlternative1::from($input->{'stockStatus'}), true => $input->{'stockStatus'}, default => throw new \InvalidArgumentException("could not build property 'stockStatus' from JSON"),
			};
		} $taxClass = null;
		if (isset($input->{'taxClass'})) {
			$taxClass = match (true) {
				is_string($input->{'taxClass'}), true => $input->{'taxClass'}, default => throw new \InvalidArgumentException("could not build property 'taxClass' from JSON"),
			};
		} $taxStatus = null;
		if (isset($input->{'taxStatus'})) {
			$taxStatus = match (true) {
				JobActionsBasicTaxStatusAlternative1::tryFrom($input->{'taxStatus'}) !== null => JobActionsBasicTaxStatusAlternative1::from($input->{'taxStatus'}), true => $input->{'taxStatus'}, default => throw new \InvalidArgumentException("could not build property 'taxStatus' from JSON"),
			};
		} $totalSales = null;
		if (isset($input->{'totalSales'})) {
			$totalSales = (int) $input->{'totalSales'};
		} $obj = new self();
		$obj->id = $id;
		$obj->parentId = $parentId;
		$obj->name = $name;
		$obj->descriptionLong = $descriptionLong;
		$obj->descriptionShort = $descriptionShort;
		$obj->imageId = $imageId;
		$obj->galleryImageIds = $galleryImageIds;
		$obj->postStatus = $postStatus;
		$obj->sku = $sku;
		$obj->regularPrice = $regularPrice;
		$obj->salePrice = $salePrice;
		$obj->stock = $stock;
		$obj->stockStatus = $stockStatus;
		$obj->taxClass = $taxClass;
		$obj->taxStatus = $taxStatus;
		$obj->totalSales = $totalSales;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->id)) {
			$output['id'] = $this->id;
		} if (isset($this->parentId)) {
			$output['parentId'] = $this->parentId;
		} if (isset($this->name)) {
			$output['name'] = $this->name;
		} if (isset($this->descriptionLong)) {
			$output['descriptionLong'] = $this->descriptionLong;
		} if (isset($this->descriptionShort)) {
			$output['descriptionShort'] = $this->descriptionShort;
		} if (isset($this->imageId)) {
			$output['imageId'] = match (true) {
				is_int($this->imageId), true => $this->imageId,
			};
		} if (isset($this->galleryImageIds)) {
			$output['galleryImageIds'] = $this->galleryImageIds;
		} if (isset($this->postStatus)) {
			$output['postStatus'] = $this->postStatus->value;
		} if (isset($this->sku)) {
			$output['sku'] = $this->sku;
		} if (isset($this->regularPrice)) {
			$output['regularPrice'] = match (true) {
				is_int($this->regularPrice) || is_float($this->regularPrice), true => $this->regularPrice,
			};
		} if (isset($this->salePrice)) {
			$output['salePrice'] = match (true) {
				is_int($this->salePrice) || is_float($this->salePrice), true => $this->salePrice,
			};
		} if (isset($this->stock)) {
			$output['stock'] = match (true) {
				is_int($this->stock), true => $this->stock,
			};
		} if (isset($this->stockStatus)) {
			$output['stockStatus'] = match (true) {
				$this->stockStatus instanceof JobActionsBasicStockStatusAlternative1 => $this->stockStatus->value, true => $this->stockStatus,
			};
		} if (isset($this->taxClass)) {
			$output['taxClass'] = match (true) {
				is_string($this->taxClass), true => $this->taxClass,
			};
		} if (isset($this->taxStatus)) {
			$output['taxStatus'] = match (true) {
				$this->taxStatus instanceof JobActionsBasicTaxStatusAlternative1 => $this->taxStatus->value, true => $this->taxStatus,
			};
		} if (isset($this->totalSales)) {
			$output['totalSales'] = $this->totalSales;
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->imageId)) {
			$this->imageId = match (true) {
				is_int($this->imageId), true => $this->imageId,
			};
		} if (isset($this->regularPrice)) {
			$this->regularPrice = match (true) {
				is_int($this->regularPrice) || is_float($this->regularPrice), true => $this->regularPrice,
			};
		} if (isset($this->salePrice)) {
			$this->salePrice = match (true) {
				is_int($this->salePrice) || is_float($this->salePrice), true => $this->salePrice,
			};
		} if (isset($this->stock)) {
			$this->stock = match (true) {
				is_int($this->stock), true => $this->stock,
			};
		} if (isset($this->stockStatus)) {
			$this->stockStatus = match (true) {
				$this->stockStatus instanceof JobActionsBasicStockStatusAlternative1, true => $this->stockStatus,
			};
		} if (isset($this->taxClass)) {
			$this->taxClass = match (true) {
				is_string($this->taxClass), true => $this->taxClass,
			};
		} if (isset($this->taxStatus)) {
			$this->taxStatus = match (true) {
				$this->taxStatus instanceof JobActionsBasicTaxStatusAlternative1, true => $this->taxStatus,
			};
		}
	}
}
