<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class Job {
	private static array $schema = ['title' => 'job', 'type' => 'object', 'additionalProperties' => false, 'required' => ['id', 'type', 'actions', 'status', 'totalItems', 'processedItems', 'startTime', 'finishTime', 'user'], 'properties' => ['id' => ['type' => 'integer'], 'type' => ['type' => 'string', 'enum' => ['product_update']], 'actions' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'integer'], 'parentId' => ['type' => 'integer'], 'name' => ['type' => 'string'], 'descriptionLong' => ['type' => 'string'], 'descriptionShort' => ['type' => 'string'], 'imageId' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'galleryImageIds' => ['type' => 'array', 'items' => ['type' => 'integer']], 'postStatus' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'sku' => ['type' => 'string'], 'regularPrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'salePrice' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'stock' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'stockStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'taxClass' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'taxStatus' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'totalSales' => ['type' => 'integer']]], 'special' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['regularPriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'regularPricePercentage' => ['type' => 'number'], 'regularPriceAbsolute' => ['type' => 'number'], 'regularPriceUseSaleAsReference' => ['type' => 'boolean'], 'salePriceMode' => ['type' => 'string', 'enum' => ['fixed', 'absolute', 'percentage', 'clear']], 'salePricePercentage' => ['type' => 'number'], 'salePriceAbsolute' => ['type' => 'number'], 'salePriceUseRegularAsReference' => ['type' => 'boolean'], 'productGroupUpdates' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['add' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]], 'remove' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]]]]]]]], 'status' => ['type' => 'string', 'enum' => ['pending', 'running', 'finished_successfully', 'finished_with_errors', 'stopped']], 'totalItems' => ['type' => 'integer'], 'processedItems' => ['type' => 'integer'], 'startTime' => ['type' => 'string', 'format' => 'date-time'], 'finishTime' => ['type' => ['string', 'null'], 'format' => 'date-time'], 'user' => ['anyOf' => [['type' => ['object'], 'required' => ['id', 'name'], 'additionalProperties' => false, 'properties' => ['id' => ['type' => 'integer'], 'name' => ['type' => 'string']]], ['type' => 'null']]], 'products' => ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'required' => ['id', 'status', 'changes', 'creationTime', 'finishTime'], 'properties' => ['id' => ['type' => 'integer'], 'status' => ['type' => 'string', 'enum' => ['pending', 'success', 'error']], 'creationTime' => ['type' => 'string', 'format' => 'date-time'], 'finishTime' => ['type' => ['string', 'null'], 'format' => 'date-time'], 'changes' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['acf' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]], 'new' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]]], 'required' => ['old', 'new']], 'basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'parentId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'name' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionLong' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionShort' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'imageId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'galleryImageIds' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'array', 'items' => ['type' => 'integer']], 'new' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'postStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'new' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']]]], 'sku' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'regularPrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'salePrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'stock' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'stockStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]]]], 'taxClass' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]]]], 'taxStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]]]], 'totalSales' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]]]], 'customMeta' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]]], 'required' => ['old', 'new']], 'defaultTaxonomy' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']], 'productAttribute' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']]]], 'error' => ['anyOf' => [['type' => ['object'], 'required' => ['field', 'expected', 'actual'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['value_mismatch'], 'default' => 'value_mismatch'], 'field' => ['type' => 'string'], 'expected' => ['type' => ['string', 'number', 'array', 'null']], 'actual' => ['type' => ['string', 'number', 'array', 'null']]]], ['type' => ['object'], 'required' => ['message'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['unknown_error'], 'default' => 'unknown_error'], 'message' => ['type' => 'string']]]]]]]]]];
	private int $id;
	private JobType $type;
	private JobActions $actions;
	private JobStatus $status;
	private int $totalItems;
	private int $processedItems;
	private \DateTime $startTime;
	private $finishTime;
	private $user;
	private ?array $products = null;

	public function __construct(int $id, JobType $type, JobActions $actions, JobStatus $status, int $totalItems, int $processedItems, \DateTime $startTime, $finishTime, $user) {
		$this->id = $id;
		$this->type = $type;
		$this->actions = $actions;
		$this->status = $status;
		$this->totalItems = $totalItems;
		$this->processedItems = $processedItems;
		$this->startTime = $startTime;
		$this->finishTime = $finishTime;
		$this->user = $user;
	}

	public function getId(): int {
		return $this->id;
	}

	public function getType(): JobType {
		return $this->type;
	}

	public function getActions(): JobActions {
		return $this->actions;
	}

	public function getStatus(): JobStatus {
		return $this->status;
	}

	public function getTotalItems(): int {
		return $this->totalItems;
	}

	public function getProcessedItems(): int {
		return $this->processedItems;
	}

	public function getStartTime(): \DateTime {
		return $this->startTime;
	}

	public function getFinishTime() {
		return $this->finishTime;
	}

	public function getUser() {
		return $this->user;
	}

	public function getProducts(): ?array {
		return $this->products ?? null;
	}

	public function withId(int $id): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($id, self::$schema['properties']['id']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->id = $id;

		return $clone;
	}

	public function withType(JobType $type): self {
		$clone = clone $this;
		$clone->type = $type;

		return $clone;
	}

	public function withActions(JobActions $actions): self {
		$clone = clone $this;
		$clone->actions = $actions;

		return $clone;
	}

	public function withStatus(JobStatus $status): self {
		$clone = clone $this;
		$clone->status = $status;

		return $clone;
	}

	public function withTotalItems(int $totalItems): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($totalItems, self::$schema['properties']['totalItems']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->totalItems = $totalItems;

		return $clone;
	}

	public function withProcessedItems(int $processedItems): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($processedItems, self::$schema['properties']['processedItems']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->processedItems = $processedItems;

		return $clone;
	}

	public function withStartTime(\DateTime $startTime): self {
		$clone = clone $this;
		$clone->startTime = $startTime;

		return $clone;
	}

	public function withFinishTime($finishTime): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($finishTime, self::$schema['properties']['finishTime']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->finishTime = $finishTime;

		return $clone;
	}

	public function withUser($user): self {
		$clone = clone $this;
		$clone->user = $user;

		return $clone;
	}

	public function withProducts(array $products): self {
		$clone = clone $this;
		$clone->products = $products;

		return $clone;
	}

	public function withoutProducts(): self {
		$clone = clone $this;
		unset($clone->products);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): Job {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $id = (int) $input->{'id'};
		$type = JobType::from($input->{'type'});
		$actions = JobActions::buildFromInput($input->{'actions'}, validate: $validate);
		$status = JobStatus::from($input->{'status'});
		$totalItems = (int) $input->{'totalItems'};
		$processedItems = (int) $input->{'processedItems'};
		$startTime = new \DateTime($input->{'startTime'});
		$finishTime = $input->{'finishTime'};
		$user = match (true) {
			JobUserAlternative1::validateInput($input->{'user'}, true) => JobUserAlternative1::buildFromInput($input->{'user'}, validate: $validate), true => $input->{'user'}, default => throw new \InvalidArgumentException("could not build property 'user' from JSON"),
		};
		$products = null;
		if (isset($input->{'products'})) {
			$products = array_map(fn (array|object $i): JobProductsItem => JobProductsItem::buildFromInput($i, validate: $validate), $input->{'products'});
		} $obj = new self($id, $type, $actions, $status, $totalItems, $processedItems, $startTime, $finishTime, $user);
		$obj->products = $products;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['id'] = $this->id;
		$output['type'] = $this->type->value;
		$output['actions'] = $this->actions->toJson();
		$output['status'] = $this->status->value;
		$output['totalItems'] = $this->totalItems;
		$output['processedItems'] = $this->processedItems;
		$output['startTime'] = $this->startTime->format(\DateTime::ATOM);
		$output['finishTime'] = $this->finishTime;
		$output['user'] = match (true) {
			$this->user instanceof JobUserAlternative1 => $this->user->toJson(), true => $this->user,
		};
		if (isset($this->products)) {
			$output['products'] = array_map(fn (JobProductsItem $i) => $i->toJson(), $this->products);
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->actions = clone $this->actions;
		$this->startTime = clone $this->startTime;
		$this->user = match (true) {
			$this->user instanceof JobUserAlternative1 => clone $this->user, true => $this->user,
		};
		if (isset($this->products)) {
			$this->products = array_map(fn (JobProductsItem $i) => clone $i, $this->products);
		}
	}
}
