<?php

namespace ShopManagerPro\Images;

class ImageAPI {
	public const SCHEMA = ['title' => 'images', 'type' => 'object', 'additionalProperties' => ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['filename', 'createdAt', 'modifiedAt', 'fileSize', 'width', 'height'], 'properties' => ['filename' => ['type' => 'string'], 'createdAt' => ['type' => 'string'], 'modifiedAt' => ['type' => 'string'], 'fileSize' => ['type' => ['integer', 'null']], 'width' => ['type' => 'integer'], 'height' => ['type' => 'integer']]]]];

	public static function init() {
		add_action('rest_api_init', [self::class, 'registerRoutes']);
	}

	public static function registerRoutes() {
		register_rest_route(\ShopManagerPro\Shared\Utils\Constants::API_NAMESPACE, '/images', [['methods' => 'GET', 'callback' => [self::class, 'getImages'], 'permission_callback' => [\ShopManagerPro\Shared\CapabilityService::class, 'requireReadCapability']], 'schema' => fn () => self::SCHEMA]);
	}

	public static function getImages(\WP_REST_Request $request) {
		$images = ImageRepository::getUploadedImages();

		return rest_ensure_response($images);
	}
}
