<?php

declare(strict_types=1);

namespace ShopManagerPro\Filters\DTO\Generated;

class FilterConditionsItemField {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'required' => ['type', 'key'], 'properties' => ['type' => ['type' => 'string', 'enum' => ['acf', 'basic', 'defaultTaxonomy', 'germanMarket', 'customMeta', 'productAttribute']], 'key' => ['type' => 'string']]];
	private FilterConditionsItemFieldType $type;
	private string $key;

	public function __construct(FilterConditionsItemFieldType $type, string $key) {
		$this->type = $type;
		$this->key = $key;
	}

	public function getType(): FilterConditionsItemFieldType {
		return $this->type;
	}

	public function getKey(): string {
		return $this->key;
	}

	public function withType(FilterConditionsItemFieldType $type): self {
		$clone = clone $this;
		$clone->type = $type;

		return $clone;
	}

	public function withKey(string $key): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($key, self::$schema['properties']['key']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->key = $key;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): FilterConditionsItemField {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $type = FilterConditionsItemFieldType::from($input->{'type'});
		$key = $input->{'key'};
		$obj = new self($type, $key);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['type'] = $this->type->value;
		$output['key'] = $this->key;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
